/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorOverNaturalModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> OVER = TConstruct.createKey((String)"over_natural_armor");

    public ArmorOverNaturalModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorOverNaturalModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(OVER, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(OVER, (Object)0);
            if (level > 0) {
                living.f_19802_ += 5;
                if (RANDOM.nextFloat() <= 0.2f * (float)level && attacker != null) {
                    attacker.m_6469_(DamageSource.f_19319_, event.getAmount() * 0.1f * (float)level);
                }
            }
        });
    }
}

